/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.registry;

import java.io.File;
import java.util.ArrayList;
import org.eclipse.core.internal.registry.Namespace;
import org.eclipse.core.internal.registry.NestedRegistryModelObject;
import org.eclipse.core.internal.runtime.CompatibilityHelper;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPluginDescriptor;

public class ExtensionPoint
extends NestedRegistryModelObject
implements IExtensionPoint {
    private String id = null;
    private IExtension[] extensions = null;
    private String schemaReference;

    public IExtension[] getExtensions() {
        IExtension[] tmpExtensions = this.extensions;
        if (tmpExtensions == null) {
            return new IExtension[0];
        }
        return tmpExtensions;
    }

    public String getSchemaReference() {
        return this.schemaReference == null ? "" : this.schemaReference.replace(File.separatorChar, '/');
    }

    public String getSchema() {
        return this.schemaReference;
    }

    public String getSimpleIdentifier() {
        return this.id;
    }

    public IExtension getExtension(String id) {
        if (id == null) {
            return null;
        }
        IExtension[] tmpExtensions = this.extensions;
        if (tmpExtensions == null) {
            return null;
        }
        int i = 0;
        while (i < tmpExtensions.length) {
            if (id.equals(tmpExtensions[i].getUniqueIdentifier())) {
                return tmpExtensions[i];
            }
            ++i;
        }
        return null;
    }

    public String getUniqueIdentifier() {
        return String.valueOf(this.getNamespace()) + "." + this.getSimpleIdentifier();
    }

    public void setExtensions(IExtension[] value) {
        this.extensions = value;
    }

    public void setSchema(String value) {
        this.schemaReference = value;
    }

    public void setSimpleIdentifier(String value) {
        this.id = value;
    }

    public String getNamespace() {
        Namespace parent = (Namespace)this.getParent();
        return parent.isFragment() ? parent.getHostIdentifier() : parent.getName();
    }

    public String getLabel() {
        String s = this.getName();
        if (s == null) {
            return "";
        }
        return s;
    }

    public String toString() {
        return this.getUniqueIdentifier();
    }

    public IConfigurationElement[] getConfigurationElements() {
        IExtension[] tmpExtensions = this.extensions;
        if (tmpExtensions == null || tmpExtensions.length == 0) {
            return new IConfigurationElement[0];
        }
        ArrayList<IConfigurationElement> result = new ArrayList<IConfigurationElement>();
        int i = 0;
        while (i < tmpExtensions.length) {
            IConfigurationElement[] toAdd = tmpExtensions[i].getConfigurationElements();
            int j = 0;
            while (j < toAdd.length) {
                result.add(toAdd[j]);
                ++j;
            }
            ++i;
        }
        return result.toArray(new IConfigurationElement[result.size()]);
    }

    public IPluginDescriptor getDeclaringPluginDescriptor() {
        return CompatibilityHelper.getPluginDescriptor(this.getNamespace());
    }
}

