/*
 * Decompiled with CFR 0.152.
 */
package org.apache.soap.server;

import java.io.FileReader;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import org.apache.soap.Fault;
import org.apache.soap.SOAPException;
import org.apache.soap.encoding.SOAPMappingRegistry;
import org.apache.soap.encoding.soapenc.BeanSerializer;
import org.apache.soap.rpc.Call;
import org.apache.soap.rpc.Parameter;
import org.apache.soap.rpc.Response;
import org.apache.soap.server.DeploymentDescriptor;
import org.apache.soap.server.TypeMappingSerializer;
import org.apache.soap.transport.SOAPTransport;
import org.apache.soap.transport.http.SOAPHTTPConnection;
import org.apache.soap.util.xml.Deserializer;
import org.apache.soap.util.xml.QName;
import org.apache.soap.util.xml.Serializer;
import org.apache.soap.util.xml.XMLParserUtils;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

public class ServiceManagerClient {
    URL routerURL;
    Vector params = new Vector();
    Call call = new Call();
    String userName;
    String password;
    static /* synthetic */ Class class$org$apache$soap$server$DeploymentDescriptor;
    static /* synthetic */ Class class$org$apache$soap$server$TypeMapping;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$org$apache$soap$server$ServiceManagerClient;

    public ServiceManagerClient(URL uRL) {
        Deserializer deserializer = new BeanSerializer();
        this.routerURL = uRL;
        SOAPMappingRegistry sOAPMappingRegistry = this.call.getSOAPMappingRegistry();
        sOAPMappingRegistry.mapTypes("http://schemas.xmlsoap.org/soap/encoding/", new QName("http://xml.apache.org/xml-soap", "DeploymentDescriptor"), class$org$apache$soap$server$DeploymentDescriptor != null ? class$org$apache$soap$server$DeploymentDescriptor : (class$org$apache$soap$server$DeploymentDescriptor = ServiceManagerClient.class$("org.apache.soap.server.DeploymentDescriptor")), (Serializer)((Object)deserializer), deserializer);
        deserializer = new TypeMappingSerializer();
        sOAPMappingRegistry.mapTypes("http://schemas.xmlsoap.org/soap/encoding/", new QName("http://xml.apache.org/xml-soap", "TypeMapping"), class$org$apache$soap$server$TypeMapping != null ? class$org$apache$soap$server$TypeMapping : (class$org$apache$soap$server$TypeMapping = ServiceManagerClient.class$("org.apache.soap.server.TypeMapping")), (Serializer)((Object)deserializer), deserializer);
    }

    private static void badUsage() {
        System.err.println("Usage: java " + (class$org$apache$soap$server$ServiceManagerClient != null ? class$org$apache$soap$server$ServiceManagerClient : (class$org$apache$soap$server$ServiceManagerClient = ServiceManagerClient.class$("org.apache.soap.server.ServiceManagerClient"))).getName() + " [-auth username:password] url operation arguments");
        System.err.println("where");
        System.err.println("\tusername and password is the HTTP Basic authentication info");
        System.err.println("\turl is the Apache SOAP router's URL whose services are managed");
        System.err.println("\toperation and arguments are:");
        System.err.println("\t\tdeploy deployment-descriptor-file.xml");
        System.err.println("\t\tlist");
        System.err.println("\t\tquery service-name");
        System.err.println("\t\tundeploy service-name");
        System.exit(1);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public void deploy(DeploymentDescriptor deploymentDescriptor) throws SOAPException {
        Parameter parameter = new Parameter("descriptor", class$org$apache$soap$server$DeploymentDescriptor != null ? class$org$apache$soap$server$DeploymentDescriptor : (class$org$apache$soap$server$DeploymentDescriptor = ServiceManagerClient.class$("org.apache.soap.server.DeploymentDescriptor")), deploymentDescriptor, null);
        this.invokeMethod("deploy", parameter);
    }

    private Response invokeMethod(String string, Parameter parameter) throws SOAPException {
        Object object;
        this.call.setTargetObjectURI("urn:xml-soap-service-management-service");
        this.call.setMethodName(string);
        this.call.setEncodingStyleURI("http://schemas.xmlsoap.org/soap/encoding/");
        if (this.userName != null) {
            object = new SOAPHTTPConnection();
            ((SOAPHTTPConnection)object).setUserName(this.userName);
            ((SOAPHTTPConnection)object).setPassword(this.password);
            this.call.setSOAPTransport((SOAPTransport)object);
        }
        if (parameter != null) {
            this.params.removeAllElements();
            this.params.addElement(parameter);
            this.call.setParams(this.params);
        } else {
            this.call.setParams(null);
        }
        object = this.call.invoke(this.routerURL, "");
        if (((Response)object).generatedFault()) {
            Fault fault = ((Response)object).getFault();
            System.out.println("Ouch, the call failed: ");
            System.out.println("  Fault Code   = " + fault.getFaultCode());
            System.out.println("  Fault String = " + fault.getFaultString());
        }
        return object;
    }

    public String[] list() throws SOAPException {
        Response response = this.invokeMethod("list", null);
        if (!response.generatedFault()) {
            Parameter parameter = response.getReturnValue();
            return (String[])parameter.getValue();
        }
        return null;
    }

    public static void main(String[] stringArray) throws Exception {
        String string;
        Object object;
        String string2 = null;
        String string3 = null;
        if (stringArray.length < 2) {
            ServiceManagerClient.badUsage();
        }
        int n = 0;
        if (stringArray[0].equals("-auth")) {
            if (stringArray.length < 4) {
                ServiceManagerClient.badUsage();
            }
            if (((StringTokenizer)(object = new StringTokenizer(stringArray[1], ":"))).countTokens() != 2) {
                ServiceManagerClient.badUsage();
            }
            string2 = ((StringTokenizer)object).nextToken();
            string3 = ((StringTokenizer)object).nextToken();
            n = 2;
        }
        object = new ServiceManagerClient(new URL(stringArray[n]));
        if (n == 2) {
            ((ServiceManagerClient)object).setUserName(string2);
            ((ServiceManagerClient)object).setPassword(string3);
        }
        if ((string = stringArray[n + 1]).equals("deploy")) {
            if (stringArray.length != n + 3) {
                ServiceManagerClient.badUsage();
            }
            FileReader fileReader = new FileReader(stringArray[n + 2]);
            DocumentBuilder documentBuilder = XMLParserUtils.getXMLDocBuilder();
            Document document = documentBuilder.parse(new InputSource(fileReader));
            ((ServiceManagerClient)object).deploy(DeploymentDescriptor.fromXML(document.getDocumentElement()));
        } else if (string.equals("undeploy")) {
            if (stringArray.length != n + 3) {
                ServiceManagerClient.badUsage();
            }
            ((ServiceManagerClient)object).undeploy(stringArray[n + 2]);
        } else if (string.equals("list")) {
            String[] stringArray2 = ((ServiceManagerClient)object).list();
            if (stringArray2 != null) {
                System.out.println("Deployed Services:");
                int n2 = 0;
                while (n2 < stringArray2.length) {
                    System.out.println("\t" + stringArray2[n2]);
                    ++n2;
                }
            }
        } else if (string.equals("query")) {
            DeploymentDescriptor deploymentDescriptor;
            if (stringArray.length != n + 3) {
                ServiceManagerClient.badUsage();
            }
            if ((deploymentDescriptor = ((ServiceManagerClient)object).query(stringArray[n + 2])) != null) {
                deploymentDescriptor.toXML(new OutputStreamWriter(System.out));
            }
        } else {
            ServiceManagerClient.badUsage();
        }
    }

    public DeploymentDescriptor query(String string) throws SOAPException {
        Parameter parameter = new Parameter("name", class$java$lang$String != null ? class$java$lang$String : (class$java$lang$String = ServiceManagerClient.class$("java.lang.String")), string, null);
        Response response = this.invokeMethod("query", parameter);
        if (!response.generatedFault()) {
            Parameter parameter2 = response.getReturnValue();
            return (DeploymentDescriptor)parameter2.getValue();
        }
        return null;
    }

    public void setPassword(String string) {
        this.password = string;
    }

    public void setUserName(String string) {
        this.userName = string;
    }

    public void undeploy(String string) throws SOAPException {
        Parameter parameter = new Parameter("name", class$java$lang$String != null ? class$java$lang$String : (class$java$lang$String = ServiceManagerClient.class$("java.lang.String")), string, null);
        this.invokeMethod("undeploy", parameter);
    }
}

