/*
 * Decompiled with CFR 0.152.
 */
package ProcesadorDocumentos.XMLHelpers;

import ProcesadorDocumentos.XMLHelpers.AttrContainer;
import ProcesadorDocumentos.XMLHelpers.InfoFiltro;
import ProcesadorDocumentos.XMLHelpers.StringContainer;
import ProcesadorDocumentos.XMLHelpers.documentWrapper;
import java.io.Serializable;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ContainerItem
implements Serializable {
    protected static int NODE_ERROR = -1;
    protected static int NODE_ATTRIBUTE = 1;
    protected static int NODE_CONTAINER = 2;
    protected static int NODE_CDATA = 3;
    protected static int NODE_CONTAINER_ITEM = 4;
    protected Properties attributes = new Properties();
    protected Hashtable containers = new Hashtable();
    private String[] cdatas = new String[]{"<", ">", "=", "&", "[", "]"};
    private static int CDATA_SIZE = 6;
    protected String TextoDelNodo = null;
    protected String NombreDelNodo = null;
    protected String NombreDelNodoHijo = null;
    private documentWrapper document = null;
    static /* synthetic */ Class class$ProcesadorDocumentos$XMLHelpers$ContainerItem;

    public ContainerItem() {
    }

    public ContainerItem(ContainerItem item) {
        this.attributes = new Properties();
        this.containers = new Hashtable();
        this.copyFromItem(item);
    }

    public void copyFromItem(ContainerItem item) {
        Enumeration<?> props = item.getAttributes().propertyNames();
        while (props.hasMoreElements()) {
            String propName = (String)props.nextElement();
            this.attributes.setProperty(propName, item.getAttribute(propName));
        }
        Enumeration keys = item.getContainers().keys();
        while (keys.hasMoreElements()) {
            String k = (String)keys.nextElement();
            this.containers.put(k, item.getContainer(k).clone());
        }
    }

    public String getName() {
        return this.NombreDelNodo;
    }

    public Object clone() {
        return new ContainerItem(this);
    }

    public AttrContainer addContainer(String Name, String ItemName) {
        AttrContainer r = new AttrContainer(Name, ItemName);
        r.setDocument(this.getDocument());
        this.containers.put(Name, r);
        return r;
    }

    public AttrContainer addContainer(AttrContainer r) {
        r.setDocument(this.getDocument());
        this.containers.put(r.getName(), r);
        return r;
    }

    public void removeContainer(String Name) {
        this.containers.remove(Name);
    }

    public AttrContainer getContainer(String Name) {
        AttrContainer r = null;
        if (this.containers != null) {
            r = (AttrContainer)this.containers.get(Name);
        }
        return r;
    }

    public boolean existContainer(String Name) {
        boolean r = false;
        if (this.containers != null) {
            r = this.containers.get(Name) != null;
        }
        return r;
    }

    public Hashtable getContainers() {
        return this.containers;
    }

    protected void setContainers(Hashtable cons) {
        this.containers = cons;
    }

    public void setAttribute(String Name, String Value) {
        StringContainer s = new StringContainer();
        s.setName(Name);
        if (s.EsNombreAtributo()) {
            this.attributes.setProperty(Name, Value);
        } else {
            s.getItemContenedor(this).setAttribute(s.getNewName(), Value);
        }
    }

    public void unsetAttribute(String Name) {
        ((Hashtable)this.attributes).remove(Name);
    }

    public void setDateAttribute(String Name, Date Value) {
        StringContainer s = new StringContainer();
        s.setName(Name);
        if (s.EsNombreAtributo()) {
            this.attributes.setProperty(Name, new SimpleDateFormat("dd-MM-yyyy").format(Value));
        } else {
            s.getItemContenedor(this).setDateAttribute(s.getNewName(), Value);
        }
    }

    public void setDateAttribute(String Name, Date Value, String Formato) {
        StringContainer s = new StringContainer();
        s.setName(Name);
        if (s.EsNombreAtributo()) {
            this.attributes.setProperty(Name, new SimpleDateFormat(Formato).format(Value));
        } else {
            s.getItemContenedor(this).setDateAttribute(s.getNewName(), Value);
        }
    }

    public void setDateTimeAttribute(String Name, Date Value) {
        StringContainer s = new StringContainer();
        s.setName(Name);
        if (s.EsNombreAtributo()) {
            this.attributes.setProperty(Name, new SimpleDateFormat("dd-MM-yyyy HH:mm").format(Value));
        } else {
            s.getItemContenedor(this).setDateTimeAttribute(s.getNewName(), Value);
        }
    }

    public void setLongAttribute(String Name, Long Value) {
        StringContainer s = new StringContainer();
        s.setName(Name);
        if (s.EsNombreAtributo()) {
            this.attributes.setProperty(Name, Value.toString());
        } else {
            s.getItemContenedor(this).setLongAttribute(s.getNewName(), Value);
        }
    }

    public void setDoubleAttribute(String Name, Double Value) {
        StringContainer s = new StringContainer();
        s.setName(Name);
        if (s.EsNombreAtributo()) {
            this.attributes.setProperty(Name, Value.toString());
        } else {
            s.getItemContenedor(this).setDoubleAttribute(s.getNewName(), Value);
        }
    }

    public void setFloatAttribute(String Name, Float Value) {
        StringContainer s = new StringContainer();
        s.setName(Name);
        if (s.EsNombreAtributo()) {
            this.attributes.setProperty(Name, Value.toString());
        } else {
            s.getItemContenedor(this).setFloatAttribute(s.getNewName(), Value);
        }
    }

    public String getAttribute(String Name) {
        String r = null;
        StringContainer s = new StringContainer();
        s.setName(Name);
        if (s.EsNombreAtributo()) {
            if (this.attributes != null) {
                r = this.attributes.getProperty(Name);
            }
        } else {
            String NombreContenedor = s.getNombreContenedor();
            if (this.existContainer(NombreContenedor)) {
                AttrContainer cont = this.getContainer(NombreContenedor);
                int indice = s.getItem();
                if (indice <= cont.size()) {
                    ContainerItem newContainer = cont.getItem(indice);
                    r = newContainer.getAttribute(s.getNewName());
                }
            }
        }
        return r;
    }

    public String getAttribute(String Namefilter, String Name) {
        InfoFiltro filter = this.getDocument().searchFilter(Namefilter);
        String NombreContenedor = filter.getNombreContenedor();
        if (this.existContainer(NombreContenedor)) {
            AttrContainer cont = this.getContainer(NombreContenedor);
            String atributoFiltro = filter.getNombreAtributo();
            String valorFiltro = filter.getValorFiltro();
            if (atributoFiltro != null) {
                int i = 0;
                while (i < cont.size()) {
                    ContainerItem newContainer = cont.getItem(i);
                    if (newContainer.getAttribute(atributoFiltro) != null & newContainer.getAttribute(atributoFiltro).equals(valorFiltro)) {
                        String SubFiltro = filter.getNombreSubFiltro();
                        if (SubFiltro == null) {
                            return newContainer.getAttribute(Name);
                        }
                        return newContainer.getAttribute(SubFiltro, Name);
                    }
                    ++i;
                }
            } else {
                Long indice = filter.getIndiceItem();
                if (indice.intValue() < cont.size()) {
                    ContainerItem newContainer = cont.getItem(indice.intValue());
                    String SubFiltro = filter.getNombreSubFiltro();
                    if (SubFiltro == null) {
                        return newContainer.getAttribute(Name);
                    }
                    return newContainer.getAttribute(SubFiltro, Name);
                }
                System.err.println("indice fuera de rango");
            }
        }
        return "";
    }

    public Date getDateAttribute(String Name) {
        Date d = null;
        String stDate = this.getAttribute(Name);
        if (stDate != null) {
            try {
                d = new SimpleDateFormat("dd-MM-yyyy").parse(stDate);
            }
            catch (Exception E) {
                d = null;
            }
        }
        return d;
    }

    public Timestamp getSQLDateAttribute(String Name) {
        Date d = null;
        Timestamp dt = null;
        String stDate = this.getAttribute(Name);
        if (stDate != null) {
            try {
                d = new SimpleDateFormat("dd-MM-yyyy").parse(stDate);
            }
            catch (Exception E) {
                d = null;
            }
        }
        if (d != null) {
            dt = new Timestamp(d.getTime());
        }
        return dt;
    }

    public Date getDateTimeAttribute(String Name) {
        Date d = null;
        String stDate = this.getAttribute(Name);
        if (stDate != null) {
            try {
                d = new SimpleDateFormat("dd-MM-yyyy HH:mm").parse(stDate);
            }
            catch (Exception E) {
                d = null;
            }
        }
        return d;
    }

    public Timestamp getSQLDateTimeAttribute(String Name) {
        Date d = null;
        Timestamp dt = null;
        String stDate = this.getAttribute(Name);
        if (stDate != null) {
            try {
                d = new SimpleDateFormat("dd-MM-yyyy HH:mm").parse(stDate);
            }
            catch (Exception E) {
                d = null;
            }
        }
        if (d != null) {
            dt = new Timestamp(d.getTime());
        }
        return dt;
    }

    public Long getLongAttribute(String Name) {
        Long r = null;
        String st = this.getAttribute(Name);
        if (st != null) {
            try {
                r = Long.valueOf(st);
            }
            catch (Exception E) {
                r = null;
            }
        }
        return r;
    }

    public Double getDoubleAttribute(String Name) {
        Double r = null;
        String st = this.getAttribute(Name);
        if (st != null) {
            try {
                r = Double.valueOf(st);
            }
            catch (Exception E) {
                r = null;
            }
        }
        return r;
    }

    public Float getFloatAttribute(String Name) {
        Float r = null;
        String st = this.getAttribute(Name);
        if (st != null) {
            try {
                r = Float.valueOf(st);
            }
            catch (Exception E) {
                r = null;
            }
        }
        return r;
    }

    public boolean existAttribute(String Name) {
        boolean r = false;
        if (this.attributes != null) {
            r = this.attributes.getProperty(Name) != null;
        }
        return r;
    }

    public Properties getAttributes() {
        return this.attributes;
    }

    protected void setAttributes(Properties attrs) {
        this.attributes = attrs;
    }

    public void setStandardFecha(String Nombre, Date Valor, String Formato) {
        if (!this.existContainer("Fechas")) {
            this.addContainer("Fechas", "fecha");
        }
        AttrContainer Fechas = this.getContainer("Fechas");
        ContainerItem nuevaFecha = null;
        Enumeration Enum2 = Fechas.getItems();
        while (Enum2.hasMoreElements()) {
            ContainerItem fecha = (ContainerItem)Enum2.nextElement();
            String nombreItem = fecha.getAttribute("nombre");
            if (!nombreItem.equals(Nombre)) continue;
            nuevaFecha = fecha;
        }
        if (nuevaFecha == null) {
            nuevaFecha = Fechas.addItem();
        }
        nuevaFecha.setAttribute("nombre", Nombre);
        nuevaFecha.setAttribute("valor", new SimpleDateFormat(Formato).format(Valor));
    }

    public void setStandardFecha(String Nombre, Date Valor) {
        if (!this.existContainer("Fechas")) {
            this.addContainer("Fechas", "fecha");
        }
        AttrContainer Fechas = this.getContainer("Fechas");
        ContainerItem nuevaFecha = null;
        Enumeration Enum2 = Fechas.getItems();
        while (Enum2.hasMoreElements()) {
            ContainerItem fecha = (ContainerItem)Enum2.nextElement();
            String nombreItem = fecha.getAttribute("nombre");
            if (!nombreItem.equals(Nombre)) continue;
            nuevaFecha = fecha;
        }
        if (nuevaFecha == null) {
            nuevaFecha = Fechas.addItem();
        }
        nuevaFecha.setAttribute("nombre", Nombre);
        nuevaFecha.setAttribute("valor", new SimpleDateFormat("dd-MM-yyyy").format(Valor));
    }

    public Timestamp getStandardFecha(String Nombre) {
        if (!this.existContainer("Fechas")) {
            return null;
        }
        try {
            AttrContainer Fechas = this.getContainer("Fechas");
            Enumeration Enum2 = Fechas.getItems();
            while (Enum2.hasMoreElements()) {
                ContainerItem fecha = (ContainerItem)Enum2.nextElement();
                String nombreItem = fecha.getAttribute("nombre");
                if (!nombreItem.equals(Nombre)) continue;
                Date D = new SimpleDateFormat("dd-MM-yyyy").parse(fecha.getAttribute("valor"));
                return new Timestamp(D.getTime());
            }
        }
        catch (Exception E) {
            E.printStackTrace();
        }
        return null;
    }

    public Timestamp getStandardFecha(String Nombre, String formato) {
        if (!this.existContainer("Fechas")) {
            return null;
        }
        try {
            AttrContainer Fechas = this.getContainer("Fechas");
            Enumeration Enum2 = Fechas.getItems();
            while (Enum2.hasMoreElements()) {
                ContainerItem fecha = (ContainerItem)Enum2.nextElement();
                String nombreItem = fecha.getAttribute("nombre");
                if (!nombreItem.equals(Nombre)) continue;
                Date D = new SimpleDateFormat(formato).parse(fecha.getAttribute("valor"));
                return new Timestamp(D.getTime());
            }
        }
        catch (Exception E) {
            E.printStackTrace();
        }
        return null;
    }

    public void setStandardLocacion(String Nombre, String Codigo, String Descripcion) {
        if (!this.existContainer("Locaciones")) {
            this.addContainer("Locaciones", "locacion");
        }
        AttrContainer Locaciones = this.getContainer("Locaciones");
        ContainerItem nuevaLocacion = null;
        boolean eliminar = false;
        int indiceEliminar = 0;
        int i = 0;
        while (i < Locaciones.size()) {
            ContainerItem locacion = Locaciones.getItem(i);
            String nombreItem = locacion.getAttribute("nombre");
            if (Codigo.trim().length() == 0 && Descripcion.trim().length() == 0) {
                if (nombreItem.equals(Nombre)) {
                    indiceEliminar = i;
                    eliminar = true;
                    break;
                }
            } else if (nombreItem.equals(Nombre)) {
                nuevaLocacion = locacion;
            }
            ++i;
        }
        if (!eliminar) {
            if (Codigo != null && !Codigo.equals("") && Descripcion != null && !Descripcion.equals("")) {
                if (nuevaLocacion == null) {
                    nuevaLocacion = Locaciones.addItem();
                }
                nuevaLocacion.setAttribute("nombre", Nombre);
                nuevaLocacion.setAttribute("codigo", Codigo);
                nuevaLocacion.setAttribute("descripcion", Descripcion);
            }
        } else {
            Locaciones.removeItem(indiceEliminar);
        }
    }

    public String getStandardCodigoLocacion(String Nombre) {
        if (!this.existContainer("Locaciones")) {
            return null;
        }
        AttrContainer Locaciones = this.getContainer("Locaciones");
        Enumeration Enum2 = Locaciones.getItems();
        while (Enum2.hasMoreElements()) {
            ContainerItem locacion = (ContainerItem)Enum2.nextElement();
            String nombreItem = locacion.getAttribute("nombre");
            if (!nombreItem.equals(Nombre)) continue;
            return locacion.getAttribute("codigo");
        }
        return null;
    }

    public String getStandardDescripcionLocacion(String Nombre) {
        if (!this.existContainer("Locaciones")) {
            return null;
        }
        AttrContainer Locaciones = this.getContainer("Locaciones");
        Enumeration Enum2 = Locaciones.getItems();
        while (Enum2.hasMoreElements()) {
            ContainerItem locacion = (ContainerItem)Enum2.nextElement();
            String nombreItem = locacion.getAttribute("nombre");
            if (!nombreItem.equals(Nombre)) continue;
            return locacion.getAttribute("descripcion");
        }
        return null;
    }

    public ContainerItem setStandardParticipacion(String Nombre, Long Id, String TipoId, String NacionId, String ValorId, String Nombres, String Direccion) {
        if (!this.existContainer("Participaciones")) {
            this.addContainer("Participaciones", "participacion");
        }
        AttrContainer Participaciones = this.getContainer("Participaciones");
        ContainerItem nuevaParticipacion = null;
        Enumeration Enum2 = Participaciones.getItems();
        while (Enum2.hasMoreElements()) {
            ContainerItem participacion = (ContainerItem)Enum2.nextElement();
            String nombreItem = participacion.getAttribute("nombre");
            if (!nombreItem.equals(Nombre)) continue;
            nuevaParticipacion = participacion;
        }
        if (nuevaParticipacion == null) {
            nuevaParticipacion = Participaciones.addItem();
        }
        nuevaParticipacion.setAttribute("nombre", Nombre);
        if (Id != null) {
            nuevaParticipacion.setAttribute("id", Id.toString());
        }
        if (TipoId != null) {
            nuevaParticipacion.setAttribute("tipo-id", TipoId);
        }
        if (NacionId != null) {
            nuevaParticipacion.setAttribute("nacion-id", NacionId);
        }
        if (ValorId != null) {
            nuevaParticipacion.setAttribute("valor-id", ValorId);
        }
        if (Nombres != null) {
            nuevaParticipacion.setAttribute("nombres", Nombres);
        }
        if (Direccion != null) {
            nuevaParticipacion.setAttribute("direccion", Direccion);
        }
        return nuevaParticipacion;
    }

    public ContainerItem setStandardParticipacion(String Nombre, Long Id, String TipoId, String NacionId, String ValorId, String Nombres, String Direccion, String CodigoPais) {
        ContainerItem New = this.setStandardParticipacion(Nombre, Id, TipoId, NacionId, ValorId, Nombres, Direccion);
        if (CodigoPais != null) {
            New.setAttribute("codigo-pais", CodigoPais);
        }
        return New;
    }

    public ContainerItem setStandardParticipacion(String Nombre, String Codigo, String Nombres, String Direccion) {
        if (!this.existContainer("Participaciones")) {
            this.addContainer("Participaciones", "participacion");
        }
        AttrContainer Participaciones = this.getContainer("Participaciones");
        ContainerItem nuevaParticipacion = null;
        Enumeration Enum2 = Participaciones.getItems();
        while (Enum2.hasMoreElements()) {
            ContainerItem participacion = (ContainerItem)Enum2.nextElement();
            String nombreItem = participacion.getAttribute("nombre");
            if (!nombreItem.equals(Nombre)) continue;
            nuevaParticipacion = participacion;
        }
        if (nuevaParticipacion == null) {
            nuevaParticipacion = Participaciones.addItem();
        }
        nuevaParticipacion.setAttribute("nombre", Nombre);
        if (Codigo != null) {
            nuevaParticipacion.setAttribute("codigo", Codigo);
        }
        if (Nombres != null) {
            nuevaParticipacion.setAttribute("nombres", Nombres);
        }
        if (Direccion != null) {
            nuevaParticipacion.setAttribute("direccion", Direccion);
        }
        return nuevaParticipacion;
    }

    public ContainerItem setStandardParticipacion(String Nombre, Long Id, String TipoId, String NacionId, String ValorId, String Nombres, String Direccion, String Comuna, String CodigoPais, Long IdDireccion, String CodigoComuna, String NombrePais) {
        if (!this.existContainer("Participaciones")) {
            this.addContainer("Participaciones", "participacion");
        }
        AttrContainer Participaciones = this.getContainer("Participaciones");
        ContainerItem nuevaParticipacion = null;
        boolean eliminar = false;
        int indiceEliminar = 0;
        int i = 0;
        while (i < Participaciones.size()) {
            ContainerItem participacion = Participaciones.getItem(i);
            String nombreItem = participacion.getAttribute("nombre");
            if (ValorId.trim().length() == 0 && Nombres.trim().length() == 0) {
                if (nombreItem.equals(Nombre)) {
                    indiceEliminar = i;
                    eliminar = true;
                    break;
                }
            } else if (nombreItem.equals(Nombre)) {
                nuevaParticipacion = participacion;
            }
            ++i;
        }
        if (!eliminar) {
            if (Nombres.trim().length() > 0) {
                if (nuevaParticipacion == null) {
                    nuevaParticipacion = Participaciones.addItem();
                }
                nuevaParticipacion.setAttribute("nombre", Nombre);
                if (Id != null) {
                    nuevaParticipacion.setAttribute("id", Id.toString());
                }
                if (TipoId != null) {
                    nuevaParticipacion.setAttribute("tipo-id", TipoId);
                }
                if (NacionId != null) {
                    nuevaParticipacion.setAttribute("nacion-id", NacionId);
                }
                if (ValorId != null) {
                    nuevaParticipacion.setAttribute("valor-id", ValorId);
                }
                if (Nombres != null) {
                    nuevaParticipacion.setAttribute("nombres", Nombres);
                }
                if (Direccion != null) {
                    nuevaParticipacion.setAttribute("direccion", Direccion);
                }
                if (Comuna != null) {
                    nuevaParticipacion.setAttribute("comuna", Comuna);
                }
                if (CodigoPais != null) {
                    nuevaParticipacion.setAttribute("codigo-pais", CodigoPais);
                }
                if (IdDireccion != null) {
                    nuevaParticipacion.setLongAttribute("id-direccion", IdDireccion);
                }
                if (CodigoComuna != null) {
                    nuevaParticipacion.setAttribute("codigo-comuna", CodigoComuna);
                }
                if (NombrePais != null) {
                    nuevaParticipacion.setAttribute("nombre-pais", NombrePais);
                }
            }
        } else {
            Participaciones.removeItem(indiceEliminar);
        }
        return nuevaParticipacion;
    }

    public ContainerItem setStandardParticipacion(String Nombre, Long Id, String TipoId, String NacionId, String ValorId, String Nombres, String Direccion, String Comuna, String CodigoPais, Long IdDireccion, String CodigoComuna) {
        ContainerItem New = this.setStandardParticipacion(Nombre, Id, TipoId, NacionId, ValorId, Nombres, Direccion, Comuna, CodigoPais, IdDireccion, CodigoComuna);
        if (CodigoPais != null) {
            New.setAttribute("codigo-pais", CodigoPais);
        }
        if (IdDireccion != null) {
            New.setLongAttribute("id-direccion", IdDireccion);
        }
        if (CodigoComuna != null) {
            New.setAttribute("codigo-comuna", CodigoComuna);
        }
        return New;
    }

    public ContainerItem setStandardParticipacion(String Nombre, String Codigo, String Nombres, String Direccion, String Comuna, String CodigoPais, Long IdDireccion, String CodigoComuna, String NombrePais) {
        if (!this.existContainer("Participaciones")) {
            this.addContainer("Participaciones", "participacion");
        }
        AttrContainer Participaciones = this.getContainer("Participaciones");
        ContainerItem nuevaParticipacion = null;
        Enumeration Enum2 = Participaciones.getItems();
        while (Enum2.hasMoreElements()) {
            ContainerItem participacion = (ContainerItem)Enum2.nextElement();
            String nombreItem = participacion.getAttribute("nombre");
            if (!nombreItem.equals(Nombre)) continue;
            nuevaParticipacion = participacion;
        }
        if (nuevaParticipacion == null) {
            nuevaParticipacion = Participaciones.addItem();
        }
        nuevaParticipacion.setAttribute("nombre", Nombre);
        if (Codigo != null) {
            nuevaParticipacion.setAttribute("codigo", Codigo);
        }
        if (Nombres != null) {
            nuevaParticipacion.setAttribute("nombres", Nombres);
        }
        if (Direccion != null) {
            nuevaParticipacion.setAttribute("direccion", Direccion);
        }
        if (Comuna != null) {
            nuevaParticipacion.setAttribute("comuna", Comuna);
        }
        if (CodigoPais != null) {
            nuevaParticipacion.setAttribute("codigo-pais", CodigoPais);
        }
        if (IdDireccion != null) {
            nuevaParticipacion.setLongAttribute("id-direccion", IdDireccion);
        }
        if (CodigoComuna != null) {
            nuevaParticipacion.setAttribute("codigo-comuna", CodigoComuna);
        }
        if (NombrePais != null) {
            nuevaParticipacion.setAttribute("nombre-pais", NombrePais);
        }
        return nuevaParticipacion;
    }

    public ContainerItem getStandardParticipacion(String Nombre) {
        if (!this.existContainer("Participaciones")) {
            return null;
        }
        AttrContainer Participaciones = this.getContainer("Participaciones");
        Enumeration Enum2 = Participaciones.getItems();
        while (Enum2.hasMoreElements()) {
            ContainerItem participacion = (ContainerItem)Enum2.nextElement();
            String nombreItem = participacion.getAttribute("nombre");
            if (nombreItem == null || !nombreItem.equals(Nombre)) continue;
            return participacion;
        }
        return null;
    }

    public Vector getStandardParticipaciones(String Nombre) {
        if (!this.existContainer("Participaciones")) {
            return null;
        }
        AttrContainer Participaciones = this.getContainer("Participaciones");
        Vector ret = new Vector();
        Enumeration Enum2 = Participaciones.getItems();
        while (Enum2.hasMoreElements()) {
            ContainerItem participacion = (ContainerItem)Enum2.nextElement();
            String nombreItem = participacion.getAttribute("nombre");
            if (!nombreItem.equals(Nombre)) continue;
            return ret;
        }
        return ret;
    }

    public int getStandardParticipacionesCount(String Nombre) {
        return this.getStandardParticipaciones(Nombre).size();
    }

    public void addObservacion(String obs, Date Fecha, String loginUsuario, String Nombre) {
        if (!this.existContainer("Observaciones")) {
            this.addContainer("Observaciones", "observacion");
        }
        AttrContainer Observaciones = this.getContainer("Observaciones");
        ContainerItem observacion = Observaciones.addItem();
        observacion.setAttribute("contenido", obs);
        observacion.setAttribute("fecha", new SimpleDateFormat("dd-MM-yyyy HH:mm:ss").format(Fecha));
        observacion.setAttribute("login-usuario", loginUsuario);
        observacion.setAttribute("nombre", Nombre);
    }

    public int getObservacionesCount() {
        if (!this.existContainer("Observaciones")) {
            return 0;
        }
        AttrContainer Observaciones = this.getContainer("Observaciones");
        return Observaciones.size();
    }

    public String getContenidoObservacion(int i) {
        if (!this.existContainer("Observaciones")) {
            return null;
        }
        AttrContainer Observaciones = this.getContainer("Observaciones");
        return Observaciones.getItem(i).getAttribute("contenido");
    }

    public Date getFechaObservacion(int i) {
        if (!this.existContainer("Observaciones")) {
            return null;
        }
        AttrContainer Observaciones = this.getContainer("Observaciones");
        try {
            return new SimpleDateFormat("dd-MM-yyyy HH:mm:ss").parse(Observaciones.getItem(i).getAttribute("fecha"));
        }
        catch (Exception E) {
            E.printStackTrace();
            return null;
        }
    }

    public String getLoginUsuarioObservacion(int i) {
        if (!this.existContainer("Observaciones")) {
            return null;
        }
        AttrContainer Observaciones = this.getContainer("Observaciones");
        return Observaciones.getItem(i).getAttribute("login-usuario");
    }

    public ContainerItem getObservacion(String Nombre) {
        if (!this.existContainer("Observaciones")) {
            return null;
        }
        AttrContainer Observaciones = this.getContainer("Observaciones");
        Enumeration Enum2 = Observaciones.getItems();
        while (Enum2.hasMoreElements()) {
            ContainerItem observacion = (ContainerItem)Enum2.nextElement();
            String nombreItem = observacion.getAttribute("nombre");
            if (!nombreItem.equals(Nombre)) continue;
            return observacion;
        }
        return null;
    }

    public String toXML(int Indent) {
        Enumeration<Object> Enum2;
        String tabs = "                                                                                                                                                                                                       ";
        StringBuffer r = new StringBuffer();
        if (this.attributes != null) {
            Enum2 = this.attributes.propertyNames();
            while (Enum2.hasMoreElements()) {
                String name = (String)Enum2.nextElement();
                String value = this.attributes.getProperty(name);
                r.append(tabs.substring(1, Indent) + "<" + name + ">" + this.DataCode(value) + "</" + name + ">\n");
            }
        }
        if (this.containers != null) {
            Enum2 = this.containers.elements();
            while (Enum2.hasMoreElements()) {
                AttrContainer C = (AttrContainer)Enum2.nextElement();
                if (C.size() <= 0) continue;
                r.append(C.toXML(Indent));
            }
        }
        return r.toString();
    }

    private int getNodeType(Node Node2) {
        NodeList L = Node2.getChildNodes();
        if (L.getLength() == 1) {
            Node Child = L.item(0);
            if (Child.getNodeType() == 3) {
                this.NombreDelNodo = Node2.getNodeName();
                this.TextoDelNodo = Child.getNodeValue();
                return NODE_ATTRIBUTE;
            }
            if (Child.getNodeType() == 4) {
                this.NombreDelNodo = Node2.getNodeName();
                this.TextoDelNodo = Child.getNodeValue();
                return NODE_CDATA;
            }
        }
        int i = 0;
        while (i < L.getLength()) {
            Node Child = L.item(i);
            if (Child.getNodeType() == 1) {
                this.NombreDelNodo = Node2.getNodeName();
                this.NombreDelNodoHijo = Child.getNodeName();
                return NODE_CONTAINER;
            }
            ++i;
        }
        return NODE_ERROR;
    }

    protected void fromXMLNode(Node Node2) {
        NodeList L = Node2.getChildNodes();
        int i = 0;
        while (i < L.getLength()) {
            Node Child = L.item(i);
            if (Child.getNodeType() == 1) {
                switch (this.getNodeType(Child)) {
                    case 1: {
                        this.setAttribute(this.NombreDelNodo, this.TextoDelNodo);
                        break;
                    }
                    case 2: {
                        AttrContainer C = this.addContainer(this.NombreDelNodo, this.NombreDelNodoHijo);
                        C.fromXMLNode((Element)Child);
                        break;
                    }
                    case 3: {
                        this.setAttribute(this.NombreDelNodo, this.TextoDelNodo);
                    }
                }
            }
            ++i;
        }
    }

    public String toXMLOnlyData(int Indent) {
        Enumeration<Object> Enum2;
        String tabs = "                                                                                                                                                                                                       ";
        StringBuffer r = new StringBuffer();
        if (this.attributes != null) {
            Enum2 = this.attributes.propertyNames();
            while (Enum2.hasMoreElements()) {
                String name = (String)Enum2.nextElement();
                String value = this.attributes.getProperty(name);
                r.append(tabs.substring(1, Indent) + "<" + name + ">" + this.DataCode(value) + "</" + name + ">\n");
            }
        }
        if (this.containers != null) {
            Enum2 = this.containers.elements();
            while (Enum2.hasMoreElements()) {
                boolean export;
                AttrContainer C = (AttrContainer)Enum2.nextElement();
                boolean bl = export = Indent != 2 || !C.getName().equals("Control") && !C.getName().equals("Firmas") && !C.getName().equals("versiones") && !C.getName().equals("workflow");
                if (!export) continue;
                r.append(C.toXML(Indent));
            }
        }
        return r.toString();
    }

    public String DataCode(String st) {
        int i = 0;
        while (i < CDATA_SIZE) {
            String s = this.cdatas[i];
            if (st.indexOf(s) != -1) {
                return "<![CDATA[" + st + "]]>";
            }
            ++i;
        }
        return st;
    }

    public void setDocument(documentWrapper d) {
        this.document = d;
    }

    public documentWrapper getDocument() {
        return this.document;
    }

    private void anotaEliminacionAtributo(AttrContainer changes, String propName, String valorAntiguo) {
        ContainerItem cambio = changes.addItem();
        cambio.setAttribute("tipo", "borra-atributo");
        cambio.setAttribute("nombre", propName);
        cambio.setAttribute("valor", valorAntiguo);
    }

    private void reversaEliminacionAtributo(ContainerItem destino, ContainerItem cambio) {
        String nombreAtributo = cambio.getAttribute("nombre");
        String valor = cambio.getAttribute("valor");
        destino.setAttribute(nombreAtributo, valor);
    }

    private void anotaModificacionAtributo(AttrContainer changes, String propName, String valorAntiguo) {
        ContainerItem cambio = changes.addItem();
        cambio.setAttribute("tipo", "modifica-atributo");
        cambio.setAttribute("nombre", propName);
        cambio.setAttribute("valor-anterior", valorAntiguo);
    }

    private void reversaModificacionAtributo(ContainerItem destino, ContainerItem cambio) {
        String nombreAtributo = cambio.getAttribute("nombre");
        String valor = cambio.getAttribute("valor-anterior");
        destino.setAttribute(nombreAtributo, valor);
    }

    private void anotaInsercionAtributo(AttrContainer changes, String propName) {
        ContainerItem cambio = changes.addItem();
        cambio.setAttribute("tipo", "agrega-atributo");
        cambio.setAttribute("nombre", propName);
    }

    private void reversaInsercionAtributo(ContainerItem destino, ContainerItem cambio) {
        String nombreAtributo = cambio.getAttribute("nombre");
        destino.unsetAttribute(nombreAtributo);
    }

    private void anotaEliminacionContenedor(AttrContainer changes, AttrContainer cAntiguo) {
        ContainerItem cambio = changes.addItem();
        cambio.setAttribute("tipo", "borra-contenedor");
        cambio.setAttribute("nombre-contenedor", cAntiguo.getName());
        cambio.setAttribute("nombre-item", cAntiguo.getItemName());
        AttrContainer items = cambio.addContainer("items", "item");
        documentWrapper nuevoItemVacio = new documentWrapper("items", "1.0");
        int i = 0;
        while (i < cAntiguo.size()) {
            ContainerItem itemAntiguo = cAntiguo.getItem(i);
            ContainerItem item = items.addItem();
            AttrContainer controlCambios = item.addContainer("control-cambios", "cambio");
            this.compareVersion(nuevoItemVacio, itemAntiguo, controlCambios);
            ++i;
        }
    }

    private void reversaEliminacionContenedor(ContainerItem item, ContainerItem cambio) {
        String nombreContenedor = cambio.getAttribute("nombre-contenedor");
        String nombreItems = cambio.getAttribute("nombre-item");
        AttrContainer nuevoContenedor = item.addContainer(nombreContenedor, nombreItems);
        AttrContainer itemsCambios = cambio.getContainer("items");
        int i = 0;
        while (i < itemsCambios.size()) {
            ContainerItem itemCambios = itemsCambios.getItem(i);
            ContainerItem nuevoItem = nuevoContenedor.addItem();
            this.reversaCambios(nuevoItem, itemCambios);
            ++i;
        }
    }

    private void anotaModificacionContenedor(AttrContainer changes, AttrContainer cAntiguo, AttrContainer cNuevo) {
        AttrContainer controlCambios;
        ContainerItem item;
        ContainerItem cambio = changes.addItem();
        cambio.setAttribute("tipo", "modifica-contenedor");
        cambio.setAttribute("nombre-contenedor", cAntiguo.getName());
        int n = cNuevo.size();
        if (cNuevo.size() < cAntiguo.size()) {
            AttrContainer itemsEliminados = cambio.addContainer("items-eliminados", "item");
            documentWrapper nuevoItemVacio = new documentWrapper("items", "1.0");
            int i = cNuevo.size();
            while (i < cAntiguo.size()) {
                ContainerItem itemAntiguo = cAntiguo.getItem(i);
                item = itemsEliminados.addItem();
                controlCambios = item.addContainer("control-cambios", "cambio");
                this.compareVersion(nuevoItemVacio, itemAntiguo, controlCambios);
                ++i;
            }
        }
        if (cNuevo.size() > cAntiguo.size()) {
            n = cAntiguo.size();
            cambio.setLongAttribute("numero-items-agregados", new Long(cNuevo.size() - cAntiguo.size()));
        }
        AttrContainer itemsModificados = cambio.addContainer("items-modificados", "item");
        int i = 0;
        while (i < n) {
            ContainerItem itemAntiguo = cAntiguo.getItem(i);
            ContainerItem itemNuevo = cNuevo.getItem(i);
            if (!itemNuevo.equals(itemAntiguo)) {
                item = itemsModificados.addItem();
                item.setLongAttribute("numero-item", new Long(i));
                controlCambios = item.addContainer("control-cambios", "cambio");
                this.compareVersion(itemNuevo, itemAntiguo, controlCambios);
            }
            ++i;
        }
    }

    private void reversaModificacionContenedor(ContainerItem item, ContainerItem cambio) {
        AttrContainer itemsModificados;
        Long nItemsAgregados;
        String nombreContenedor = cambio.getAttribute("nombre-contenedor");
        AttrContainer contenedor = item.getContainer(nombreContenedor);
        AttrContainer itemsEliminados = cambio.getContainer("items-eliminados");
        if (itemsEliminados != null) {
            int i = 0;
            while (i < itemsEliminados.size()) {
                ContainerItem itemEliminado = itemsEliminados.getItem(i);
                ContainerItem nuevoItem = contenedor.addItem();
                this.reversaCambios(nuevoItem, itemEliminado);
                ++i;
            }
        }
        if ((nItemsAgregados = cambio.getLongAttribute("numero-items-agregados")) != null) {
            int i = 0;
            while (i < nItemsAgregados.intValue()) {
                contenedor.removeItem(contenedor.size() - 1);
                ++i;
            }
        }
        if ((itemsModificados = cambio.getContainer("items-modificados")) != null) {
            int i = 0;
            while (i < itemsModificados.size()) {
                ContainerItem itemModificado = itemsModificados.getItem(i);
                int numeroItem = itemModificado.getLongAttribute("numero-item").intValue();
                ContainerItem itemAReversar = contenedor.getItem(numeroItem);
                this.reversaCambios(itemAReversar, itemModificado);
                ++i;
            }
        }
    }

    private void anotaInsercionContenedor(AttrContainer changes, AttrContainer cNuevo) {
        ContainerItem cambio = changes.addItem();
        cambio.setAttribute("tipo", "agrega-contenedor");
        cambio.setAttribute("nombre-contenedor", cNuevo.getName());
    }

    private void reversaInsercionContenedor(ContainerItem item, ContainerItem cambio) {
        String nombreContenedor = cambio.getAttribute("nombre-contenedor");
        if (item.getContainer(nombreContenedor) != null) {
            item.removeContainer(nombreContenedor);
        }
    }

    public void compareVersion(ContainerItem newVersion, ContainerItem oldVersion, AttrContainer changes) {
        AttrContainer cNuevo;
        String valorNuevo;
        Hashtable<String, Integer> atributosRevisados = new Hashtable<String, Integer>();
        Enumeration<?> props = oldVersion.getAttributes().propertyNames();
        while (props.hasMoreElements()) {
            String propName = (String)props.nextElement();
            String valorAntiguo = oldVersion.getAttribute(propName);
            valorNuevo = newVersion.getAttribute(propName);
            if (valorNuevo == null) {
                this.anotaEliminacionAtributo(changes, propName, valorAntiguo);
            } else if (!valorAntiguo.equals(valorNuevo)) {
                this.anotaModificacionAtributo(changes, propName, valorAntiguo);
            }
            atributosRevisados.put(propName, new Integer(0));
        }
        Enumeration<?> props2 = newVersion.getAttributes().propertyNames();
        while (props2.hasMoreElements()) {
            String propName = (String)props2.nextElement();
            if (atributosRevisados.get(propName) != null) continue;
            valorNuevo = newVersion.getAttribute(propName);
            this.anotaInsercionAtributo(changes, propName);
            atributosRevisados.put(propName, new Integer(0));
        }
        Enumeration keys = oldVersion.getContainers().keys();
        while (keys.hasMoreElements()) {
            String k = (String)keys.nextElement();
            AttrContainer cAntiguo = oldVersion.getContainer(k);
            if (cAntiguo.size() <= 0) continue;
            cNuevo = newVersion.getContainer(k);
            if (cNuevo == null || cNuevo.size() == 0) {
                this.anotaEliminacionContenedor(changes, cAntiguo);
            } else if (!cAntiguo.equals(cNuevo)) {
                this.anotaModificacionContenedor(changes, cAntiguo, cNuevo);
            }
            atributosRevisados.put(k, new Integer(0));
        }
        Enumeration keys2 = newVersion.getContainers().keys();
        while (keys2.hasMoreElements()) {
            String k = (String)keys2.nextElement();
            if (atributosRevisados.get(k) != null || (cNuevo = newVersion.getContainer(k)).size() <= 0) continue;
            this.anotaInsercionContenedor(changes, cNuevo);
            atributosRevisados.put(k, new Integer(0));
        }
    }

    public ContainerItem reversaCambios(ContainerItem item, ContainerItem cambiosVersion) {
        AttrContainer cambios = cambiosVersion.getContainer("control-cambios");
        if (cambios == null) {
            return item;
        }
        int i = 0;
        while (i < cambios.size()) {
            ContainerItem cambio = cambios.getItem(i);
            String tipo = cambio.getAttribute("tipo");
            if (tipo.equals("borra-atributo")) {
                this.reversaEliminacionAtributo(item, cambio);
            }
            if (tipo.equals("modifica-atributo")) {
                this.reversaModificacionAtributo(item, cambio);
            }
            if (tipo.equals("agrega-atributo")) {
                this.reversaInsercionAtributo(item, cambio);
            }
            if (tipo.equals("borra-contenedor")) {
                this.reversaEliminacionContenedor(item, cambio);
            }
            if (tipo.equals("modifica-contenedor")) {
                this.reversaModificacionContenedor(item, cambio);
            }
            if (tipo.equals("agrega-contenedor")) {
                this.reversaInsercionContenedor(item, cambio);
            }
            ++i;
        }
        return item;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(class$ProcesadorDocumentos$XMLHelpers$ContainerItem == null ? (class$ProcesadorDocumentos$XMLHelpers$ContainerItem = ContainerItem.class$("ProcesadorDocumentos.XMLHelpers.ContainerItem")) : class$ProcesadorDocumentos$XMLHelpers$ContainerItem).isInstance(o)) {
            return false;
        }
        ContainerItem item = (ContainerItem)o;
        Enumeration<?> props = this.getAttributes().propertyNames();
        while (props.hasMoreElements()) {
            String propName = (String)props.nextElement();
            int sepNuevo = 0;
            String valorNuevo = this.getAttribute(propName);
            String valorAntiguo = item.getAttribute(propName);
            if (valorNuevo != null) {
                sepNuevo = valorNuevo.length();
                sepNuevo = valorNuevo.lastIndexOf(".", sepNuevo);
            }
            int sepAntiguo = 0;
            if (valorAntiguo != null) {
                sepAntiguo = valorAntiguo.length();
                sepAntiguo = valorAntiguo.lastIndexOf(".", sepAntiguo);
            }
            if (sepNuevo > 0 || sepAntiguo > 0) {
                if (sepNuevo > 0) {
                    valorNuevo = valorNuevo.substring(0, sepNuevo);
                }
                if (sepAntiguo > 0) {
                    valorAntiguo = valorAntiguo.substring(0, sepAntiguo);
                }
            }
            if (valorNuevo.equals(valorAntiguo)) continue;
            return false;
        }
        if (this.getContainers().size() != item.getContainers().size()) {
            return false;
        }
        Enumeration keys = this.getContainers().keys();
        while (keys.hasMoreElements()) {
            String k = (String)keys.nextElement();
            AttrContainer c = this.getContainer(k);
            if (c.equals(item.getContainer(k))) continue;
            return false;
        }
        return true;
    }

    private boolean esAtributoDef(ContainerItem defItem, String attributeName) {
        if (defItem == null || attributeName == null) {
            return false;
        }
        AttrContainer contAtributos = defItem.getContainer("atributos");
        if (contAtributos == null) {
            return false;
        }
        int i = 0;
        while (i < contAtributos.size()) {
            ContainerItem valor = contAtributos.getItem(i);
            if (valor.getAttribute("nombre").equals(attributeName)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean equals(Object o, ContainerItem defItem) {
        if (o == null) {
            return false;
        }
        if (!(class$ProcesadorDocumentos$XMLHelpers$ContainerItem == null ? (class$ProcesadorDocumentos$XMLHelpers$ContainerItem = ContainerItem.class$("ProcesadorDocumentos.XMLHelpers.ContainerItem")) : class$ProcesadorDocumentos$XMLHelpers$ContainerItem).isInstance(o)) {
            return false;
        }
        ContainerItem item = (ContainerItem)o;
        Enumeration<?> props = this.getAttributes().propertyNames();
        while (props.hasMoreElements()) {
            String propName = (String)props.nextElement();
            if (!this.esAtributoDef(defItem, propName)) continue;
            boolean sepNuevo = false;
            String valorNuevo = this.getAttribute(propName);
            String valorAntiguo = item.getAttribute(propName);
            Timestamp FValorNuevo = this.getSQLDateAttribute(propName);
            Timestamp FValorAntiguo = item.getSQLDateAttribute(propName);
            Double DValorAntiguo = this.getDoubleAttribute(propName);
            Double DValorNuevo = item.getDoubleAttribute(propName);
            if (!(FValorNuevo != null && FValorAntiguo != null ? !FValorNuevo.equals(FValorAntiguo) : (DValorAntiguo != null && DValorNuevo != null ? !DValorAntiguo.equals(DValorNuevo) : !valorNuevo.trim().toUpperCase().equals(valorAntiguo.trim().toUpperCase())))) continue;
            return false;
        }
        Enumeration keys = this.getContainers().keys();
        while (keys.hasMoreElements()) {
            String k = (String)keys.nextElement();
            AttrContainer c = this.getContainer(k);
            if (c.equals(item.getContainer(k), defItem)) continue;
            return false;
        }
        return true;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

