/*
 * Decompiled with CFR 0.152.
 */
package sms.validador;

import ProcesadorDocumentos.XMLHelpers.AttrContainer;
import ProcesadorDocumentos.XMLHelpers.ContainerItem;
import ProcesadorDocumentos.XMLHelpers.documentWrapper;
import gtime.schema.Documento;
import gtime.schema.DocumentoType;
import gtime.schema.ObjectFactory;
import java.io.File;
import java.io.FileOutputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Enumeration;
import java.util.Properties;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Validator;
import sms.soap.Start;
import sms.util.Util;
import sms.validador.CourierANUv10;

public class GTIMEv10 {
    private String file;
    private String doc;
    private boolean valid = false;

    public GTIMEv10(String file, String doc) {
        this.file = file;
        this.doc = doc;
        this.init();
    }

    private void init() {
        try {
            ObjectFactory objFactory = new ObjectFactory();
            Documento documento = objFactory.createDocumento();
            documentWrapper dw = new documentWrapper(new File(this.file));
            if (!dw.getAttribute("tipo-accion").equals("N")) {
                if (dw.getDocType().equals("GTIME")) {
                    documento.setTipo(dw.getDocType());
                }
                if (dw.getVersion().equals("1.0")) {
                    documento.setVersion(dw.getVersion());
                }
                if (dw.existAttribute("login") && !dw.getAttribute("login").equals("")) {
                    documento.setLogin(dw.getAttribute("login").trim());
                }
                if (dw.existAttribute("tipo-accion") && !dw.getAttribute("tipo-accion").equals("")) {
                    documento.setTipoAccion("I");
                } else {
                    documento.setTipoAccion(dw.getAttribute("tipo-accion").trim());
                }
                if (dw.existAttribute("numero-referencia") && !dw.getAttribute("numero-referencia").equals("")) {
                    documento.setNumeroReferencia(dw.getAttribute("numero-referencia").trim());
                }
                if (dw.existAttribute("tipo-operacion") && !dw.getAttribute("tipo-operacion").equals("")) {
                    documento.setTipoOperacion(dw.getAttribute("tipo-operacion").trim());
                }
                if (dw.existAttribute("total-bultos") && !dw.getAttribute("total-bultos").equals("")) {
                    documento.setTotalBultos(new BigInteger(dw.getAttribute("total-bultos").trim()));
                }
                if (dw.existAttribute("total-peso") && !dw.getAttribute("total-peso").equals("")) {
                    documento.setTotalPeso(new BigDecimal(dw.getAttribute("total-peso").trim()));
                }
                if (dw.existAttribute("unidad-peso") && !dw.getAttribute("unidad-peso").equals("")) {
                    documento.setUnidadPeso(dw.getAttribute("unidad-peso").trim());
                }
                if (dw.existAttribute("total-volumen") && !dw.getAttribute("total-volumen").equals("")) {
                    documento.setTotalVolumen(new BigDecimal(dw.getAttribute("total-volumen").trim()));
                }
                if (dw.existAttribute("unidad-volumen") && !dw.getAttribute("unidad-volumen").equals("")) {
                    documento.setUnidadVolumen(dw.getAttribute("unidad-volumen").trim());
                }
                if (dw.existAttribute("total-item") && !dw.getAttribute("total-item").equals("")) {
                    documento.setTotalItem(new BigInteger(dw.getAttribute("total-item").trim()));
                }
                if (dw.existAttribute("valor-declarado") && !dw.getAttribute("valor-declarado").equals("")) {
                    documento.setValorDeclarado(new BigDecimal(dw.getAttribute("valor-declarado").trim()));
                }
                if (dw.existAttribute("moneda-valor") && !dw.getAttribute("moneda-valor").equals("")) {
                    documento.setMonedaValor(dw.getAttribute("moneda-valor").trim());
                }
                if (dw.existAttribute("parcial") && !dw.getAttribute("parcial").equals("")) {
                    documento.setParcial(dw.getAttribute("parcial").trim());
                }
                this.cargaFechas(documento, dw);
                this.cargaLocaciones(documento, dw);
                this.cargaParticipantes(documento, dw);
                this.cargaTransbordos(documento, dw);
                this.cargaItems(documento, dw);
                this.cargaCargos(documento, dw);
                this.cargaReferencias(documento, dw);
                this.cargaVistosBuenos(documento, dw);
                this.cargaObservaciones(documento, dw);
                JAXBContext jc = JAXBContext.newInstance("gtime.schema");
                Validator v = jc.createValidator();
                this.valid = v.validateRoot(documento);
                if (this.valid) {
                    Marshaller m = jc.createMarshaller();
                    m.setProperty("jaxb.encoding", "ISO-8859-1");
                    m.setProperty("jaxb.formatted.output", Boolean.TRUE);
                    if (!new File(String.valueOf(Util.getPATH()) + Util.getSEPARADOR() + "mensajes").exists()) {
                        new File(String.valueOf(Util.getPATH()) + Util.getSEPARADOR() + "mensajes").mkdirs();
                    }
                    String xml = String.valueOf(Util.getPATH()) + Util.getSEPARADOR() + "mensajes" + Util.getSEPARADOR() + this.doc;
                    m.marshal((Object)documento, new FileOutputStream(xml));
                }
            } else {
                this.valid = new CourierANUv10(this.file, this.doc).isValid();
            }
        }
        catch (Exception e) {
            if (!this.valid) {
                Start.pe("\t=> [" + this.doc + "]: GTIME con Estructura Invalida.-");
                if (e.toString().indexOf(".Abort") != -1) {
                    String msgError = e.toString().substring(e.toString().indexOf(".Abort") + 19, e.toString().length() - 1);
                    Start.pe("\t+ " + msgError);
                } else {
                    Start.pe("\t+ " + e.toString());
                }
                Start.pe("\t=> Moviendo documento [" + this.doc + "] a [SMS_Home\\xml\\invalidos].-\n\n");
            }
            System.err.println("\t=> [" + this.doc + "]: Error manipulando archivo. Posiblemente no tiene permisos necesarios.-\n\n");
            this.valid = false;
        }
    }

    private void cargaFechas(Documento documento, documentWrapper dw) {
        ObjectFactory objFactory = new ObjectFactory();
        try {
            if (dw.existContainer("Fechas")) {
                DocumentoType.FechasType FcTp = objFactory.createDocumentoTypeFechasType();
                AttrContainer atc = dw.getContainer("Fechas");
                Enumeration enm = atc.getItems();
                while (enm.hasMoreElements()) {
                    ContainerItem ci = (ContainerItem)enm.nextElement();
                    Properties prop = ci.getAttributes();
                    DocumentoType.FechasType.FechaType fcTp = objFactory.createDocumentoTypeFechasTypeFechaType();
                    if (prop.containsKey("nombre") && !prop.get("nombre").equals("")) {
                        fcTp.setNombre(String.valueOf(prop.get("nombre")).trim());
                    }
                    if (prop.containsKey("valor") && !prop.get("valor").equals("")) {
                        fcTp.setValor(String.valueOf(prop.get("valor")).trim());
                    }
                    FcTp.getFecha().add(fcTp);
                }
                documento.setFechas(FcTp);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void cargaLocaciones(Documento documento, documentWrapper dw) {
        ObjectFactory objFactory = new ObjectFactory();
        try {
            if (dw.existContainer("Locaciones")) {
                DocumentoType.LocacionesType LocTp = objFactory.createDocumentoTypeLocacionesType();
                AttrContainer atc = dw.getContainer("Locaciones");
                Enumeration enm = atc.getItems();
                while (enm.hasMoreElements()) {
                    ContainerItem ci = (ContainerItem)enm.nextElement();
                    Properties prop = ci.getAttributes();
                    DocumentoType.LocacionesType.LocacionType locTp = objFactory.createDocumentoTypeLocacionesTypeLocacionType();
                    if (prop.containsKey("codigo") && !prop.get("codigo").equals("")) {
                        locTp.setCodigo(String.valueOf(prop.get("codigo")).trim());
                    }
                    if (prop.containsKey("descripcion") && !prop.get("descripcion").equals("")) {
                        locTp.setDescripcion(String.valueOf(prop.get("descripcion")).trim());
                    }
                    if (prop.containsKey("nombre") && !prop.get("nombre").equals("")) {
                        locTp.setNombre(String.valueOf(prop.get("nombre")).trim());
                    }
                    LocTp.getLocacion().add(locTp);
                }
                documento.setLocaciones(LocTp);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void cargaParticipantes(Documento documento, documentWrapper dw) {
        ObjectFactory objFactory = new ObjectFactory();
        try {
            if (dw.existContainer("Participaciones")) {
                DocumentoType.ParticipacionesType PartTp = objFactory.createDocumentoTypeParticipacionesType();
                AttrContainer atc = dw.getContainer("Participaciones");
                Enumeration enm = atc.getItems();
                while (enm.hasMoreElements()) {
                    ContainerItem ci = (ContainerItem)enm.nextElement();
                    Properties prop = ci.getAttributes();
                    DocumentoType.ParticipacionesType.ParticipacionType partTp = objFactory.createDocumentoTypeParticipacionesTypeParticipacionType();
                    if (prop.containsKey("codigo-pais") && !prop.get("codigo-pais").equals("")) {
                        partTp.setCodigoPais(String.valueOf(prop.get("codigo-pais")).trim());
                    }
                    if (prop.containsKey("comuna") && !prop.get("comuna").equals("")) {
                        partTp.setComuna(String.valueOf(prop.get("comuna")).trim());
                    }
                    if (prop.containsKey("direccion") && !prop.get("direccion").equals("")) {
                        partTp.setDireccion(String.valueOf(prop.get("direccion")).trim());
                    }
                    if (prop.containsKey("nacion-id") && !prop.get("nacion-id").equals("")) {
                        partTp.setNacionId(String.valueOf(prop.get("nacion-id")).trim());
                    }
                    if (prop.containsKey("nombre") && !prop.get("nombre").equals("")) {
                        partTp.setNombre(String.valueOf(prop.get("nombre")).trim());
                    }
                    if (prop.containsKey("nombres") && !prop.get("nombres").equals("")) {
                        partTp.setNombres(String.valueOf(prop.get("nombres")).trim());
                    }
                    if (prop.containsKey("tipo-id") && !prop.get("tipo-id").equals("")) {
                        partTp.setTipoId(String.valueOf(prop.get("tipo-id")).trim());
                    }
                    if (prop.containsKey("valor-id") && !prop.get("valor-id").equals("")) {
                        partTp.setValorId(String.valueOf(prop.get("valor-id")).trim());
                    }
                    PartTp.getParticipacion().add(partTp);
                }
                documento.setParticipaciones(PartTp);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void cargaTransbordos(Documento documento, documentWrapper dw) {
        ObjectFactory objFactory = new ObjectFactory();
        try {
            if (dw.existContainer("Transbordos")) {
                DocumentoType.TransbordosType TranTp = objFactory.createDocumentoTypeTransbordosType();
                AttrContainer atc = dw.getContainer("Transbordos");
                Enumeration enm = atc.getItems();
                while (enm.hasMoreElements()) {
                    ContainerItem ci = (ContainerItem)enm.nextElement();
                    Properties prop = ci.getAttributes();
                    DocumentoType.TransbordosType.TransbordoType tranTp = objFactory.createDocumentoTypeTransbordosTypeTransbordoType();
                    if (prop.containsKey("cod-lugar") && !prop.get("cod-lugar").equals("")) {
                        tranTp.setCodLugar(String.valueOf(prop.get("cod-lugar")).trim());
                    }
                    if (prop.containsKey("descripcion-lugar") && !prop.get("descripcion-lugar").equals("")) {
                        tranTp.setDescripcionLugar(String.valueOf(prop.get("descripcion-lugar")).trim());
                    }
                    if (prop.containsKey("fecha-arribo") && !prop.get("fecha-arribo").equals("")) {
                        tranTp.setFechaArribo(String.valueOf(prop.get("fecha-arribo")).trim());
                    }
                    TranTp.getTransbordo().add(tranTp);
                }
                documento.setTransbordos(TranTp);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void cargaItems(Documento documento, documentWrapper dw) {
        ObjectFactory objFactory = new ObjectFactory();
        try {
            if (dw.existContainer("Items")) {
                DocumentoType.ItemsType ItTp = objFactory.createDocumentoTypeItemsType();
                AttrContainer atc = dw.getContainer("Items");
                Enumeration enm = atc.getItems();
                while (enm.hasMoreElements()) {
                    ContainerItem ci = (ContainerItem)enm.nextElement();
                    Properties prop = ci.getAttributes();
                    DocumentoType.ItemsType.ItemType itTp = objFactory.createDocumentoTypeItemsTypeItemType();
                    if (prop.containsKey("cantidad") && !prop.get("cantidad").equals("")) {
                        itTp.setCantidad(new BigDecimal(String.valueOf(prop.get("cantidad")).trim()));
                    }
                    if (prop.containsKey("descripcion") && !prop.get("descripcion").equals("")) {
                        itTp.setDescripcion(String.valueOf(prop.get("descripcion")).trim());
                    }
                    if (prop.containsKey("marcas") && !prop.get("marcas").equals("")) {
                        itTp.setMarcas(String.valueOf(prop.get("marcas")).trim());
                    }
                    if (prop.containsKey("numero-item") && !prop.get("numero-item").equals("")) {
                        itTp.setNumeroItem(new BigInteger(String.valueOf(prop.get("numero-item")).trim()));
                    }
                    if (prop.containsKey("peso-bruto") && !prop.get("peso-bruto").equals("")) {
                        itTp.setPesoBruto(new BigDecimal(String.valueOf(prop.get("peso-bruto")).trim()));
                    }
                    if (prop.containsKey("tipo-bulto") && !prop.get("tipo-bulto").equals("")) {
                        itTp.setTipoBulto(String.valueOf(prop.get("tipo-bulto")).trim());
                    }
                    if (prop.containsKey("unidad-peso") && !prop.get("unidad-peso").equals("")) {
                        itTp.setUnidadPeso(String.valueOf(prop.get("unidad-peso")).trim());
                    }
                    if (ci.existContainer("ProdItem")) {
                        AttrContainer atc2 = ci.getContainer("ProdItem");
                        Enumeration enum2 = atc2.getItems();
                        ContainerItem ci2 = (ContainerItem)enum2.nextElement();
                        Properties prop2 = ci2.getAttributes();
                        DocumentoType.ItemsType.ItemType.ProdItemType.ProditemType proditemTp = objFactory.createDocumentoTypeItemsTypeItemTypeProdItemTypeProditemType();
                        if (prop2.containsKey("cantidad") && !prop2.get("cantidad").equals("")) {
                            proditemTp.setCantidad(String.valueOf(prop2.get("cantidad")).trim());
                        }
                        if (prop2.containsKey("descripcion") && !prop2.get("descripcion").equals("")) {
                            proditemTp.setDescripcion(String.valueOf(prop2.get("descripcion")).trim());
                        }
                        if (prop2.containsKey("moneda") && !prop2.get("moneda").equals("")) {
                            proditemTp.setMoneda(String.valueOf(prop2.get("moneda")).trim());
                        }
                        if (prop2.containsKey("unidad-medida") && !prop2.get("unidad-medida").equals("")) {
                            proditemTp.setUnidadMedida(String.valueOf(prop2.get("unidad-medida")).trim());
                        }
                        if (prop2.containsKey("valor-declarado") && !prop2.get("valor-declarado").equals("")) {
                            proditemTp.setValorDeclarado(String.valueOf(prop2.get("valor-declarado")).trim());
                        }
                        DocumentoType.ItemsType.ItemType.ProdItemType prodItemTp = objFactory.createDocumentoTypeItemsTypeItemTypeProdItemType();
                        prodItemTp.getProditem().add(proditemTp);
                        itTp.setProdItem(prodItemTp);
                    }
                    ItTp.getItem().add(itTp);
                }
                documento.setItems(ItTp);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void cargaCargos(Documento documento, documentWrapper dw) {
        ObjectFactory objFactory = new ObjectFactory();
        try {
            if (dw.existContainer("Cargos")) {
                DocumentoType.CargosType CarTp = objFactory.createDocumentoTypeCargosType();
                AttrContainer atc = dw.getContainer("Cargos");
                Enumeration enm = atc.getItems();
                while (enm.hasMoreElements()) {
                    ContainerItem ci = (ContainerItem)enm.nextElement();
                    Properties prop = ci.getAttributes();
                    DocumentoType.CargosType.CargoType carTp = objFactory.createDocumentoTypeCargosTypeCargoType();
                    if (prop.containsKey("cond-pago") && !prop.get("cond-pago").equals("")) {
                        carTp.setCondPago(String.valueOf(prop.get("cond-pago")).trim());
                    }
                    if (prop.containsKey("descripcion") && !prop.get("descripcion").equals("")) {
                        carTp.setDescripcion(String.valueOf(prop.get("descripcion")).trim());
                    }
                    if (prop.containsKey("moneda") && !prop.get("moneda").equals("")) {
                        carTp.setMoneda(String.valueOf(prop.get("moneda")).trim());
                    }
                    if (prop.containsKey("monto") && !prop.get("monto").equals("")) {
                        carTp.setMonto(String.valueOf(prop.get("monto")).trim());
                    }
                    if (prop.containsKey("observaciones") && !prop.get("observaciones").equals("")) {
                        carTp.setObservaciones(String.valueOf(prop.get("observaciones")).trim());
                    }
                    if (prop.containsKey("tarifa") && !prop.get("tarifa").equals("")) {
                        carTp.setTarifa(String.valueOf(prop.get("tarifa")).trim());
                    }
                    if (prop.containsKey("tipo-cargo") && !prop.get("tipo-cargo").equals("")) {
                        carTp.setTipoCargo(String.valueOf(prop.get("tipo-cargo")).trim());
                    }
                    CarTp.getCargo().add(carTp);
                }
                documento.setCargos(CarTp);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void cargaReferencias(Documento documento, documentWrapper dw) {
        ObjectFactory objFactory = new ObjectFactory();
        try {
            if (dw.existContainer("Referencias")) {
                DocumentoType.ReferenciasType RefTp = objFactory.createDocumentoTypeReferenciasType();
                AttrContainer atc = dw.getContainer("Referencias");
                Enumeration enm = atc.getItems();
                while (enm.hasMoreElements()) {
                    ContainerItem ci = (ContainerItem)enm.nextElement();
                    Properties prop = ci.getAttributes();
                    DocumentoType.ReferenciasType.ReferenciaType refTp = objFactory.createDocumentoTypeReferenciasTypeReferenciaType();
                    if (prop.containsKey("emisor") && !prop.get("emisor").equals("")) {
                        refTp.setEmisor(String.valueOf(prop.get("emisor")).trim());
                    }
                    if (prop.containsKey("fecha") && !prop.get("fecha").equals("")) {
                        refTp.setFecha(String.valueOf(prop.get("fecha")).trim());
                    }
                    if (prop.containsKey("nac-id-emisor") && !prop.get("nac-id-emisor").equals("")) {
                        refTp.setNacIdEmisor(String.valueOf(prop.get("nac-id-emisor")).trim());
                    }
                    if (prop.containsKey("numero") && !prop.get("numero").equals("")) {
                        refTp.setNumero(String.valueOf(prop.get("numero")).trim());
                    }
                    if (prop.containsKey("observaciones") && !prop.get("observaciones").equals("")) {
                        refTp.setObservaciones(String.valueOf(prop.get("observaciones")).trim());
                    }
                    if (prop.containsKey("tipo-documento") && !prop.get("tipo-documento").equals("")) {
                        refTp.setTipoDocumento(String.valueOf(prop.get("tipo-documento")).trim());
                    }
                    if (prop.containsKey("tipo-id-emisor") && !prop.get("tipo-id-emisor").equals("")) {
                        refTp.setTipoIdEmisor(String.valueOf(prop.get("tipo-id-emisor")).trim());
                    }
                    if (prop.containsKey("tipo-referencia") && !prop.get("tipo-referencia").equals("")) {
                        refTp.setTipoReferencia(String.valueOf(prop.get("tipo-referencia")).trim());
                    }
                    if (prop.containsKey("valor-id-emisor") && !prop.get("valor-id-emisor").equals("")) {
                        refTp.setValorIdEmisor(String.valueOf(prop.get("valor-id-emisor")).trim());
                    }
                    RefTp.getReferencia().add(refTp);
                }
                documento.setReferencias(RefTp);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void cargaVistosBuenos(Documento documento, documentWrapper dw) {
        ObjectFactory objFactory = new ObjectFactory();
        try {
            if (dw.existContainer("VistosBuenos")) {
                DocumentoType.VistosBuenosType VbTp = objFactory.createDocumentoTypeVistosBuenosType();
                AttrContainer atc = dw.getContainer("VistosBuenos");
                Enumeration e = atc.getItems();
                while (e.hasMoreElements()) {
                    ContainerItem ci = (ContainerItem)e.nextElement();
                    Properties prop = ci.getAttributes();
                    DocumentoType.VistosBuenosType.VbType vbTp = objFactory.createDocumentoTypeVistosBuenosTypeVbType();
                    if (prop.containsKey("tipo-vb") && !prop.get("tipo-vb").equals("")) {
                        vbTp.setTipoVb(String.valueOf(prop.get("tipo-vb")).trim());
                    }
                    VbTp.getVb().add(vbTp);
                }
                documento.setVistosBuenos(VbTp);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void cargaObservaciones(Documento documento, documentWrapper dw) {
        ObjectFactory objFactory = new ObjectFactory();
        try {
            if (dw.existContainer("Observaciones")) {
                DocumentoType.ObservacionesType ObTp = objFactory.createDocumentoTypeObservacionesType();
                AttrContainer atc = dw.getContainer("Observaciones");
                Enumeration enm = atc.getItems();
                while (enm.hasMoreElements()) {
                    ContainerItem ci = (ContainerItem)enm.nextElement();
                    Properties prop = ci.getAttributes();
                    DocumentoType.ObservacionesType.ObservacionType obTp = objFactory.createDocumentoTypeObservacionesTypeObservacionType();
                    if (prop.containsKey("contenido") && !prop.get("contenido").equals("")) {
                        obTp.setContenido(String.valueOf(prop.get("contenido")).trim());
                    }
                    if (prop.containsKey("nombre") && !prop.get("nombre").equals("")) {
                        obTp.setNombre(String.valueOf(prop.get("nombre")).trim());
                    }
                    ObTp.getObservacion().add(obTp);
                }
                documento.setObservaciones(ObTp);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean isValid() {
        return this.valid;
    }
}

