/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.utils;

import java.io.Serializable;
import org.w3c.dom.Node;

public class NodeVector
implements Serializable,
Cloneable {
    private int m_blocksize;
    private Node[] m_map;
    protected int m_firstFree = 0;
    private int m_mapSize;

    public NodeVector() {
        this.m_blocksize = 32;
        this.m_mapSize = 0;
    }

    public NodeVector(int blocksize) {
        this.m_blocksize = blocksize;
        this.m_mapSize = 0;
    }

    public void addElement(Node value) {
        if (this.m_firstFree + 1 >= this.m_mapSize) {
            if (this.m_map == null) {
                this.m_map = new Node[this.m_blocksize];
                this.m_mapSize = this.m_blocksize;
            } else {
                this.m_mapSize += this.m_blocksize;
                Node[] newMap = new Node[this.m_mapSize];
                System.arraycopy(this.m_map, 0, newMap, 0, this.m_firstFree + 1);
                this.m_map = newMap;
            }
        }
        this.m_map[this.m_firstFree] = value;
        ++this.m_firstFree;
    }

    public void appendNodes(NodeVector nodes) {
        int nNodes = nodes.size();
        if (this.m_map == null) {
            this.m_mapSize = nNodes + this.m_blocksize;
            this.m_map = new Node[this.m_mapSize];
        } else if (this.m_firstFree + nNodes >= this.m_mapSize) {
            this.m_mapSize += nNodes + this.m_blocksize;
            Node[] newMap = new Node[this.m_mapSize];
            System.arraycopy(this.m_map, 0, newMap, 0, this.m_firstFree + nNodes);
            this.m_map = newMap;
        }
        System.arraycopy(nodes.m_map, 0, this.m_map, this.m_firstFree, nNodes);
        this.m_firstFree += nNodes;
    }

    public Object clone() throws CloneNotSupportedException {
        NodeVector clone = (NodeVector)super.clone();
        if (this.m_map != null && this.m_map == clone.m_map) {
            clone.m_map = new Node[this.m_map.length];
            System.arraycopy(this.m_map, 0, clone.m_map, 0, this.m_map.length);
        }
        return clone;
    }

    public boolean contains(Node s) {
        if (this.m_map == null) {
            return false;
        }
        int i = 0;
        while (i < this.m_firstFree) {
            Node node = this.m_map[i];
            if (node != null && node.equals(s)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public Node elementAt(int i) {
        if (this.m_map == null) {
            return null;
        }
        return this.m_map[i];
    }

    public int indexOf(Node elem) {
        if (this.m_map == null) {
            return -1;
        }
        int i = 0;
        while (i < this.m_firstFree) {
            Node node = this.m_map[i];
            if (node != null && node.equals(elem)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int indexOf(Node elem, int index) {
        if (this.m_map == null) {
            return -1;
        }
        int i = index;
        while (i < this.m_firstFree) {
            Node node = this.m_map[i];
            if (node != null && node.equals(elem)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public void insertElementAt(Node value, int at) {
        if (this.m_map == null) {
            this.m_map = new Node[this.m_blocksize];
            this.m_mapSize = this.m_blocksize;
        } else if (this.m_firstFree + 1 >= this.m_mapSize) {
            this.m_mapSize += this.m_blocksize;
            Node[] newMap = new Node[this.m_mapSize];
            System.arraycopy(this.m_map, 0, newMap, 0, this.m_firstFree + 1);
            this.m_map = newMap;
        }
        if (at <= this.m_firstFree - 1) {
            System.arraycopy(this.m_map, at, this.m_map, at + 1, this.m_firstFree - at);
        }
        this.m_map[at] = value;
        ++this.m_firstFree;
    }

    public final Node peepOrNull() {
        return this.m_map != null && this.m_firstFree > 0 ? this.m_map[this.m_firstFree - 1] : null;
    }

    public final Node peepTail() {
        return this.m_map[this.m_firstFree - 1];
    }

    public final Node peepTailSub1() {
        return this.m_map[this.m_firstFree - 2];
    }

    public final Node pop() {
        --this.m_firstFree;
        Node n = this.m_map[this.m_firstFree];
        this.m_map[this.m_firstFree] = null;
        return n;
    }

    public final Node popAndTop() {
        --this.m_firstFree;
        this.m_map[this.m_firstFree] = null;
        return this.m_firstFree == 0 ? null : this.m_map[this.m_firstFree - 1];
    }

    public final void popPair() {
        this.m_firstFree -= 2;
        this.m_map[this.m_firstFree] = null;
        this.m_map[this.m_firstFree + 1] = null;
    }

    public final void popQuick() {
        --this.m_firstFree;
        this.m_map[this.m_firstFree] = null;
    }

    public final void push(Node value) {
        int ff = this.m_firstFree;
        if (ff + 1 >= this.m_mapSize) {
            if (this.m_map == null) {
                this.m_map = new Node[this.m_blocksize];
                this.m_mapSize = this.m_blocksize;
            } else {
                this.m_mapSize += this.m_blocksize;
                Node[] newMap = new Node[this.m_mapSize];
                System.arraycopy(this.m_map, 0, newMap, 0, ff + 1);
                this.m_map = newMap;
            }
        }
        this.m_map[ff] = value;
        this.m_firstFree = ++ff;
    }

    public final void pushPair(Node v1, Node v2) {
        if (this.m_map == null) {
            this.m_map = new Node[this.m_blocksize];
            this.m_mapSize = this.m_blocksize;
        } else if (this.m_firstFree + 2 >= this.m_mapSize) {
            this.m_mapSize += this.m_blocksize;
            Node[] newMap = new Node[this.m_mapSize];
            System.arraycopy(this.m_map, 0, newMap, 0, this.m_firstFree);
            this.m_map = newMap;
        }
        this.m_map[this.m_firstFree] = v1;
        this.m_map[this.m_firstFree + 1] = v2;
        this.m_firstFree += 2;
    }

    public void removeAllElements() {
        if (this.m_map == null) {
            return;
        }
        int i = 0;
        while (i < this.m_firstFree) {
            this.m_map[i] = null;
            ++i;
        }
        this.m_firstFree = 0;
    }

    public boolean removeElement(Node s) {
        if (this.m_map == null) {
            return false;
        }
        int i = 0;
        while (i < this.m_firstFree) {
            Node node = this.m_map[i];
            if (node != null && node.equals(s)) {
                if (i > this.m_firstFree) {
                    System.arraycopy(this.m_map, i + 1, this.m_map, i - 1, this.m_firstFree - i);
                } else {
                    this.m_map[i] = null;
                }
                --this.m_firstFree;
                return true;
            }
            ++i;
        }
        return false;
    }

    public void removeElementAt(int i) {
        if (this.m_map == null) {
            return;
        }
        if (i > this.m_firstFree) {
            System.arraycopy(this.m_map, i + 1, this.m_map, i - 1, this.m_firstFree - i);
        } else {
            this.m_map[i] = null;
        }
    }

    public void setElementAt(Node node, int index) {
        if (this.m_map == null) {
            this.m_map = new Node[this.m_blocksize];
            this.m_mapSize = this.m_blocksize;
        }
        this.m_map[index] = node;
    }

    public final void setTail(Node n) {
        this.m_map[this.m_firstFree - 1] = n;
    }

    public final void setTailSub1(Node n) {
        this.m_map[this.m_firstFree - 2] = n;
    }

    public int size() {
        return this.m_firstFree;
    }
}

